/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: AP_Sem.h 1892 2014-10-08 06:50:54Z stephans $:

  Description:
    rcX semaphore function prototypes and definitions

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2011-05-20  ported from rcX V2

**************************************************************************************/

#ifndef __AP_SEM_H
#define __AP_SEM_H
 
#ifdef __cplusplus
  extern "C" {
#endif
 
  
  /***************************************************************************
  * Size of the handle that needs to be allocated when creating a semaphore
  ***************************************************************************/
  #define RX_SEMAPHORE_SIZE (52)
  
  
  /*************************************************************
  *   Function Prototypes
  *************************************************************/
  RX_RESULT FAR   rX_SemCreateSemaphore       (const STRING FAR*      pszIdn,
                                               RX_HANDLE              hSem,
                                               UINT                   uMaxProc); 
  
  RX_RESULT FAR   rX_SemIdentifySemaphore     (const STRING FAR*      pszIdn,
                                               UINT                   uInst,
                                               RX_HANDLE FAR*         phSem); 
  
  RX_RESULT FAR   rX_SemDeleteSemaphore       (RX_HANDLE              hSem); 
  
  RX_RESULT FAR   rX_SemPutSemaphore          (RX_HANDLE              hSem); 
  
  RX_RESULT FAR   rX_SemWaitForSemaphore      (RX_HANDLE              hSem,
                                               UINT                   uTimeoutOpt); 
  
  RX_RESULT FAR   rX_SemWaitForSemaphoreCount (RX_HANDLE              hSem, 
                                               UINT FAR*              puCurCnt, 
                                               UINT                   uTimeoutOpt);
  
  RX_RESULT FAR   rX_SemClearSemaphoreCount   (RX_HANDLE              hSem);
#ifdef __cplusplus
  }
#endif

#endif /* __AP_SEM_H */
